* Simulation of the resitively loaded differential pair
.LIB ekv018.mdl
.PARAM q=1.60217662E-19 kb=1.38064852E-23 kT=kb*T T=300 UT=kb*T/q
.INCLUDE param.inc
.PARAM Vin1=Vic Vin2=Vic

.OPTION DAT
.OP
.DC LIN VID.Value -500m 500m 5u compress=no compressCoeff=1 compressTolX=0 compressTolY=1u
*.DC LIN VID.Value -500u 500u 1u compress=no compressCoeff=1 compressTolX=0 compressTolY=1u
.TRACE DC {Vod = V(out1) - V(out2)}
*.MEASURE NAME=Voffset WAVEFORM=Vod ANALYSIS=DC EXTRACT=X ATY=0 CROSS=UP OCCUR=1
.MEASURE NAME=Vomax WAVEFORM=Vod ANALYSIS=DC EXTRACT=MAX
.MEASURE NAME=Vomin WAVEFORM=Vod ANALYSIS=DC EXTRACT=MIN
.MEASURE NAME=Vosw ANALYSIS=DC VALUE=Vomax-Vomin

.AC dec 101 1 1G
.TRACE  AC     {GainMagdB=DB(V(out1,out2))}
.TRACE  AC     {GainPhaseDeg=P(V(out1,out2))}
.MEASURE NAME=Adc WAVEFORM=GainMagdB ANALYSIS=AC EXTRACT=MAX
.MEASURE NAME=B WAVEFORM=GainPhaseDeg ANALYSIS=AC EXTRACT=X ATY=135 CROSS=DOWN OCCUR=1
.MEASURE NAME=GBW WAVEFORM=GainMagdB ANALYSIS=AC EXTRACT=X ATY=0 CROSS=DOWN OCCUR=1

.NOISE V(out1,out2) VID 101 1 1G op=no compress=no compressCoeff=1 compressTolX=0 compressTolY=1u
.TRACE  Noise  {SnindBv = 20 * log10(INOISE)} {SninthdBv = 20 * log10(ITHN)} {SninfldBv = 20 * log10(IFLN)}
.TRACE  Noise  {SnintotdBv = 20 * log10(INOISE)} {SninMdBv = 20 * log10(sqrt(IN(M1.INOISE)^2 + IN(M2.INOISE)^2))} {SninRdBv = 20 * log10(sqrt(IN(R1.INOISE)^2 + IN(R2.INOISE)^2))}
.MEASURE NAME=S0 WAVEFORM=SninthdBv ANALYSIS=NOISE EXTRACT=MAX
.MEASURE NAME=fk WAVEFORM=SninfldBv ANALYSIS=NOISE EXTRACT=X ATY=S0 CROSS=DOWN OCCUR=1
